<?php

namespace App\Admin\Controllers;

use Illuminate\Support\Facades\Request;
use App\Models\Custregister;
use App\Models\Visits;
use App\Models\Country;
use App\Models\State;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use App\Models\Religion;
use App\Models\Users;
use App\Models\Cast;
use Carbon\Carbon;
use App\Models\WorkTracking;
use Encore\Admin\Facades\Admin;
use App\Admin\Actions\Post\Restore;


class CustRegisterController extends AdminController
{
  /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Customer';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
   protected function grid()
    {
        
        $grid = new Grid(new Custregister());
         
          $request = Request::all();  
       $date=intval(request('d'));
          $loginId = Admin::user()->id;  
     

         if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->whereNotNull('created_id');
}
    else{
     
         $grid->model()->Where('created_id',$loginId);
    }     
     if ($date == 1) {
        if (Admin::user()->inRoles(['Administrator', 'Manager'])){
             $today = now()->toDateString(); 
    $grid->model()->whereDate('created_at', $today);
}
    else{
      $today = now()->toDateString(); 
         $grid->model()->Where('created_id',$loginId)->whereDate('created_at', $today);
    }     
   }
if ($date == 2) {
        if (Admin::user()->inRoles(['Administrator', 'Manager'])){
          
    $grid->model()->where('appointment',0);
}
    else{
   
         $grid->model()->Where('created_id',$loginId)->where('appointment',0);
    }     
   }
   if ($date == 3) {
        if (Admin::user()->inRoles(['Administrator', 'Manager'])){
          
    $grid->model()->where('religion','Christian');
}    
   }
    if ($date == 4) {
        if (Admin::user()->inRoles(['Administrator', 'Manager'])){
          
    $grid->model()->where('religion','Hindu');
}    
   }
   
    if ($date == 5) {
        if (Admin::user()->inRoles(['Administrator', 'Manager'])){
          
    $grid->model()->where('religion','Muslim');
}    
   }
   if ($date == 6){
            if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->where('member_status',0);
}
    else{
     
        $grid->model()->where(function ($query) use ($loginId) {
       
        $query->where('created_id', $loginId)->where('member_status',0);
     });
      }
        }   
        if ($date == 7){
            if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->where('member_status',1);
}
    else{
     
        $grid->model()->where(function ($query) use ($loginId) {
       
        $query->where('created_id', $loginId)->where('member_status',1);
     });
      }
        }   
       if ($date == 8){
            if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->where('member_status',2);
}
    else{
     
        $grid->model()->where(function ($query) use ($loginId) {
       
        $query->where('created_id', $loginId)->where('member_status',2);
     });
      }
        } 
         if ($date == 9){
            $today = Carbon::today()->toDateString(); 
            if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->whereNotNull('created_id')->where('calling_reminder', $today);
}
    else{
     
        $grid->model()->where(function ($query) use ($loginId) {
       
        $query->where('created_id', $loginId)->where('calling_reminder', $today);
     });
      }
        }
        $grid->model()->orderBy('id', 'desc');
         $grid->rows(function (Grid\Row $row) {
$row->column('Sl No', $row->number+1);
});

// Your custom column.
$grid->column('Sl No');

       // $grid->column('id', __('SL.NO'))->display(function ($id) {
        
           // $totalRecords = Custregister::count();
         
            //$displayedId = $totalRecords - $id + 1;
            //return $displayedId;
      // });
        $grid->column('date', __('Date'))->display(function ($date) {
        return date('d-m-Y', strtotime($date));
        })->hide();
       $grid->column('wm_id_no', __('WM ID NO'));
      
        $grid->column('call_time', __('Call Time'))->hide();
         $grid->column('calling_reminder', __('Calling Reminder'))->date('d-m-Y');
        //   $grid->column('calling_reminder', __('Calling Reminder'))->display(function ($date) {
        // return date('d/m/Y', strtotime($date));
        // });
        $grid->column('candidate_name', __('Candidate Name'));
        $grid->column('fathers_name', __("Father's Name"));
        $grid->column('mothers_name', __("Mother's Name"))->hide();
        $grid->column('house_name', __('Address'))->hide();
        $grid->column('place', __('Place/Area'));
        $grid->column('mob_1', __('Mobile 1'));
        $grid->column('mob_2', __('Mobile 2'));
        $grid->column('gender', __('Gender'))->hide();
        $grid->column('date_of_birth', __('Date Of Birth'))->hide();
        $grid->column('age', __('Age'));
        $grid->column('religion', __('Religion'));
        $grid->column('cast', __('Cast'))->hide();
        $grid->column('candidate_watsupno', __('Candidate WhatsApp Number'))->hide();
        $grid->column('candidate_email', __('Candidate Email'))->hide();
        $grid->column('workplace', __('Workplace'))->hide();
        $grid->column('qualification', __('Qualification'))->hide();
        $grid->column('remark', __('About'))->hide();
        $grid->column('task_status', __('task_status'))->hide();
       // $grid->column('follow_up', __('Follow Up'));
        $grid->column('appointment', __('Appointment'))->display(function ($appointment) {
            if($appointment === 2){
                return "No";
            }else{
                return "Yes";
            }})->hide();
        $grid->column('appointment_date', __('Appointment Date'))->hide();
        $grid->column('appointment_time', __('Appoinment_Time'))->hide();
        $grid->column('appointment_note', __('Appoinment_Note'))->hide();
        
         $grid->quickSearch('date', 'call_time', 'candidate_name', 'fathers_name', 'mothers_name', 'house_name', 'mob_1', 'mob_2',
        'gender','date_of_birth', 'age', 'religion', 'cast', 'candidate_watsupno', 'candidate_email', 'workplace', 'plan_details',
        'qualification','occupation','country','state','place','calling_status','wm_id_no','marital_status');
        
         $grid->actions(function ($actions) {
            if (request('_scope_') == 'trashed') {
                $actions->add(new Restore());
            }
            //   $actions->disableView();
        });

        $grid->filter(function ($filter) {
        $filter->disableIdFilter();
          
    $filter->like('candidate_name', 'Name');
    $filter->like('age', 'Age');
    $filter->like('religion', 'Religion');
    $filter->scope('trashed', 'Recycle Bin')->onlyTrashed();
   
    });
    if (Admin::user()->inRoles(['Administrator', 'Manager'])){
  // $grid->model()->whereNotNull('created_id');
    $grid->column('user.name', __('Staff Name'));
}

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {   
        
       

        $show = new Show(Custregister::findOrFail($id));

       // $show->field('id', __('ID'));
        $show->field('date', __('Date'));
        $show->field('call_time', __('Call Time'));
        $show->field('calling_status', __('Calling Status'));
        $show->field('candidate_name', __('Candidate Name'));
        $show->field('fathers_name', __("Father's Name"));
        $show->field('mothers_name', __("Mother's Name"));
        $show->field('house_name', __('Address'));
        $show->field('place', __('Place/Area'));
        $show->field('country',__('Country'));
        $show->field('state',__('State'));
        $show->field('mob_1', __('Mobile 1'));
        $show->field('mob_2', __('Mobile 2'));
        $show->field('gender', __('Gender'));
        $show->field('date_of_birth', __('Date of Birth'));
        $show->field('religion', __('Religion'));
        $show->field('cast', __('Cast'));
        $show->field('candidate_watsupno', __('Candidate WhatsApp Number'));
        $show->field('candidate_email', __('Candidate Email'));
        $show->field('workplace', __('Workplace'));
        $show->field('qualification', __('Qualification'));
        $show->field('occupation', __('Occupation'));
       // $show->field('follow_up', __('Follow Up'));
        $show->field('appointment_date', __('Appoinment_Date'));
        $show->field('appointment_time', __('Appoinment_Time'));
        $show->field('appointment_note', __('Appoinment_Note'));
       
        return $show;
    }

    protected function form()
    {
          $loginId = Admin::user()->id;

        $form = new Form(new Custregister());
         
     
               $cat= new Religion(); 

        $form->date('date', __('Date')) ->default(today()->format('d-m-Y'))
    ->format('DD-MM-YYYY');
        $form->time('call_time', __('Calling Time'))->format('h:mm:ss a');
        $form->select('calling_status', __('Calling Status'))->options(['Attend' => 'Attend',
         'Not attend'=>'Not attend',
         'Not available'=>'Not available',
       'No one'=> 'No one',
       'Incoming Call' => 'Incoming Call',
        'Buzy'=> 'Buzy',
        'Wrong number'=> 'Wrong number',
        'Call You Later'=>'Call You Later',
         'Does Not Exicisted'=>'Does Not Exicisted',
          'Others'=>'Others',
          ])->setWidth(4, 2);

        $form->date('calling_reminder', __('Calling Reminder'))
        ->format('DD-MM-YYYY')->rules('required');
        $form->text('candidate_name', __('Candidate Name'));
        $form->text("fathers_name", __("Father's Name"));
        $form->text("mothers_name", __("Mother's Name"));
        $form->textarea('house_name', __('Address'))->rows(5)->style('width', '300px; height: 150px;');

        $form-> select('country',__('Country'))->options(Country::pluck('name','name'));
         $form-> select('state',__('State'))->options(State::pluck('state_name','state_name'));
         $form->text('place', __('Place/Area'))->setWidth(4, 2);
        $form->mobile('mob_1', __('First Mobile Number'))->options(['mask' =>'+99 999 999 9999'])->setWidth(4, 2);
        $form->mobile('mob_2', __('Second Mobile Number'))->options(['mask' => '+99 999 999 9999'])->setWidth(4, 2);
        $form->radioCard('gender', __('Gender'))->options(['Male' => 'Male', 'Female' => 'Female'])->stacked();
       $form->date('date_of_birth', __('Date of Birth'))
    ->default(today()->subYears(18)->format('d-m-Y'))
    ->format('DD-MM-YYYY')
    ->setWidth(4, 2);
   /* ->rules(function ($field, $value) {
        $eighteenYearsAgo = Carbon::now()->subYears(18)->startOfDay();
        return [
            'required',
            'date',
            'before_or_equal:' . $eighteenYearsAgo->format('Y-m-d'),
        ];
    });*/
        $form->hidden('age', __('Age')) ->setWidth(4, 2);
        $form->select('religion', __('Religion'))->options(Religion::pluck('religion','religion'))->setWidth(4, 2);
         $form-> select('cast',__('Cast'))->options(Cast::pluck('cast_name','id'));

     /*    
     $form->select('religion', __('Religion'))
    ->options($cat::pluck('religion', 'id'))
    ->setWidth(4, 2)
    ->rules('required')
    ->load('religion_id', '/api/casts'); 
     $form->select('cast',__('Cast'))->setWidth(4, 2)->options(function($cast){
            $s = [];
            $sub_cat = Cast::find($cast);
            if($cast){
                $all_cast = Cast::select('religion_id','cast_name')->where('religion_id',$sub_cat->id)->get();
                foreach($all_cast as $sub){
                    $s[$sub->id]=$sub->cast_name;
                }
            }
            return $s;
        });
*/

/*
  $form->select('cat_id',__('Category'))
        ->options($cat::all()->pluck('name', 'id'))->setWidth(4, 2)->rules('required')
        ->load('sub_cat_id', '/admin/api/sub-categories');
        
        $form->select('sub_cat_id',__('Sub category'))->setWidth(4, 2)->options(function($sub_cat_id){
            $s = [];
            $sub_cat = SubCategory::find($sub_cat_id);
            if($sub_cat_id){
                $all_sub_cat =SubCategory::select('id','name')->where('cat_id',$sub_cat->cat_id)->get();
                foreach($all_sub_cat as $sub){
                    $s[$sub->id]=$sub->name;
                }
            }
            return $s;
        });

*/


       // $form->select('cast', __('Cast'))->options(['1'=> 'ezhava ','2'=> 'RC','3'=> 'Muslim'])->setWidth(4, 2);
        $form->text('candidate_watsupno', __('Candidate WhatsApp Number'))->options(['mask' => '999 999 9999'])->setWidth(4, 2);
        $form->email('candidate_email', __('Candidate Email'));
          $form->text('qualification', __('Qualification'));
          $form->text('occupation', __('Occupation'));
        $form->text('workplace', __('Workplace'));
      
        $form->text('remark', __('About'));
        $form->select('datasource', __('Data Source'))->options(['1'=> 'Advertisement','2'=> 'Refferal','3'=> 'Direct','4'=> 'Facebook','5'=>'Instagram','6'=>'Youtube',
       ' 7'=> '	Newspaper Advertisment',
       ' 8'=> '	Theater Advertisment',
       ' 9'=> '	Magazine Advertisment',
       '10'=> '	Tele-in',
        '11'=> '	Telemarketting',
        '12'=> '	Event/Activity',
       ' 13'=> '	Hoarding',
        '14'=> '	Notice/Pamphelt',
        '15'=> '	Radio',
        '16'=> '	Google Search',
        '17	'=> 'Social Media',
        '18'=> '	Others'
])
        ->when(2, function (Form $form) {
        $form->text('refferal_name', __('Refferal Name'));
        $form->text('refferal_no', __('Refferal Number'));
        
        });
        $form->select('marital_status', __('Marital Status'))->options(['Single'=> 'Single',
        'Divorced'=> 'Divorced','Widowed'=> 'Widowed','Separated' => 'Separated'])
       
         ->when('Separated', function (Form $form) {
         $form->number('childrens', __('childrens'));
         })
          ->when('Divorced', function (Form $form) {
         $form->number('childrens', __('childrens'));
         })
         ->when('Widowed', function (Form $form) {
         $form->number('childrens', __('childrens'));
         })->setWidth(4, 2);
        $form->hidden('task_status', __('task_status'))->default(0);
      
        $form->table('follow_up','Follow up', function ($table) {
               
                $table->text('follow_up')->rules('required');
                $table->datetime('date')->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a');
            });

        $form->radioCard('appointment','Appointment')
        ->options([
            1 =>'YES',
            0 =>'NO',
               2 =>"Not Need"
        ])->when(1, function (Form $form) {
           
           $form->date('appointment_date', __('Appointment Date')) ->default(today()->format('d-m-Y'))
    ->format('DD-MM-YYYY');
           $form->time('appointment_time', __('Appointment Time'))->format('h:mm:ss a');
           $form->textarea('appointment_note', __('Appointment Note'))->rows(5)->style('width', '600px')->style('height', '150px');
    
        })->when(0, function (Form $form) {
            
            $form->hidden('appointment_date', __('Appointment Date'))->default(date(''));
            $form->hidden('appointment_time', __('Appointment Time'))->default(date(''));
            $form->hidden('appointment_note', __('Appointment Note'))->default('');
    
        });


         //$cust = $form->model();
         
        $form->hidden('created_id')->default( $loginId);
    
        $form->divider();

        $form->saved(function (Form $form) {
            $custregister = $form->model()->id;
            $role = Admin::user()->roles;
            
              $loginId = Admin::user()->id;

        if ($custregister && $role) {
    // Assuming that $roles is a collection of roles
    $roleNames = $role->pluck('name')->implode(', ');

            $tracks = new WorkTracking();
            $tracks->customer_id = $custregister;
            $tracks->user_id =  $loginId;
            $tracks->role_name =  $roleNames;
          
            // Save the Visits record
            $tracks->save();
        }
    });
    $form->saving(function (Form $form) {
        $dateOfBirth = $form->input('date_of_birth');
            if ($dateOfBirth) {
                $dateOfBirth = Carbon::parse($dateOfBirth);
                $age = Carbon::now()->diffInYears($dateOfBirth);
                $form->input('age', $age);
            }
             
           
            
        });


        return $form;
    }
}