<?php

namespace App\Admin\Controllers;
use Encore\Admin\Facades\Admin;
//use Illuminate\Http\Request;
use Illuminate\Support\Facades\Request;
use Encore\Admin\Filters\Filter;
use App\Models\Business;
use App\Models\Custregister;
use App\Models\Users;
use App\Models\Visits;
use Encore\Admin\Controllers\AdminController;
use App\Models\Religion;
use App\Models\WorkTracking;
use App\Models\Cast;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use Carbon\Carbon;


class BusinessExecutiveController extends AdminController
{
    protected $title='Business Executive';
   
    protected function grid()

    { 
        
          $grid = new Grid(new Custregister()); // Use the Bussiness model

        $loginId = Admin::user()->id;  
          
    //   $grid = Admin::grid(Custregister::class, function (Grid $grid) use($loginId) { 
  $request = Request::all();  
       $date=intval(request('d'));

if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->whereNotNull('assign_to');
}
    else{

         $grid->model()->where('assign_to', $loginId); 
    }


    if ($date == 6){
            if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->where('member_status',0);
}
    else{
     
        $grid->model()->where(function ($query) use ($loginId) {
        $query->where('assign_to', $loginId)
              ->where('visits_status', 1)->where('member_status',0);
    });
      }
        }   
        if ($date == 7){
            if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->where('member_status',1);
}
    else{
     
        $grid->model()->where(function ($query) use ($loginId) {
        $query->where('assign_to', $loginId)
              ->where('visits_status', 1)->where('member_status',1);
    });
      }
        }   
       if ($date == 8){
            if (Admin::user()->inRoles(['Administrator', 'Manager'])){
    $grid->model()->where('member_status',2);
}
    else{
     
        $grid->model()->where(function ($query) use ($loginId) {
        $query->where('assign_to', $loginId)
              ->where('visits_status', 1)->where('member_status',2);
    });
      }
        }  
             
 if ($date == 1) {
        if (Admin::user()->inRoles(['Administrator', 'Manager'])){
             $today = now()->toDateString(); 
    $grid->model()->whereDate('updated_at', $today);
}
    else{
      $today = now()->toDateString(); 
         $grid->model()->Where('assign_to',$loginId)->whereDate('updated_at', $today)->whereNull('visits_status');
    }     
   }  
   if ($date == 2) {
        if (Admin::user()->inRoles(['Administrator', 'Manager'])){
             $grid->model()->whereNull('visits_status')->whereNotNull('assign_to');
        }
          

    else{

     
        $grid->model()->where(function ($query) use ($loginId) {
        $query->where('assign_to', $loginId)
              ->whereNull('visits_status')->where('assign_to',$loginId);
        });
   }   
   }  
         $grid->model()->orderBy('id', 'desc');
        $grid->rows(function (Grid\Row $row) {
$row->column('Sl No', $row->number+1);
});

// Your custom column.
$grid->column('Sl No');
  
      // Assuming there is a relationship between Custregister and Visits models.
     // $grid->model()->whereHas('visits', function ($business) use($loginId)  {
        //  $business->where('assign_to', $loginId);
      //});
        $grid->column('date', __('Date'))->display(function ($date) {
        return date('d-m-Y', strtotime($date));
        });
       $grid->column('wm_id_no', __('WM ID NO'));
      
      $grid->column('candidate_name', __('Candidate Name'));
      $grid->column('fathers_name', __("Father's Name"));
     // $grid->column('mothers_name', __("Mother's Name"));
      $grid->column('house_name', __('Address'));
      $grid->column('place', __('Place/Area'));
      $grid->column('mob_1', __('Mobile 1'));
      $grid->column('mob_2', __('Mobile 2'));
      $grid->column('gender', __('Gender'));
      $grid->column('age', __('Age'));
      $grid->column('religion', __('Religion'));
    //  $grid->column('cast', __('Cast'));
       $grid->column('marital_status', __('Marital Status'))->hide();
         $grid->column('appointment_date', __('Appointment Date'));
          
         // $grid = new Grid(new Business()); // Use the Bussiness model

        // $grid->column('id', __('ID'));
        // $grid->column('date', __('Date'));
        // $grid->column('in_time', __('In Time'));
        // $grid->column('expectations', __('Expectations'));
        // $grid->column('family_status', __('Family Status'));
        // $grid->column('house_details', __('House Details'));
        // $grid->column('service_charge_details', __('Service Charge Details'));
        // $grid->column('matching_profile_details', __('Matching Profile Details'));
        // $grid->column('payment_chance', __('Payment Chance'));
        // $grid->column('payment_details', __('Payment Details'));
        // $grid->column('offer', __('Offer'));
        // $grid->column('location', __('Location'));
        // $grid->column('landmark', __('Landmark'));
        // $grid->column('map', __('Map'));
        // $grid->column('latitude','Latitude');
        // $grid->column('longitude','Longitude');
        // $grid->column('out_time', __('Out Time'));
        // $grid->column('remark', __('Remark'));
        // $grid->column('created_at', __('Created At'));
        // $grid->column('updated_at', __('Updated At'));

       

      $grid->disableCreateButton();

      $grid->actions(function ($actions) {
           
             $actions->disableView();// Disable the view action
        });
         $grid->filter(function ($filter) {
        $filter->disableIdFilter();
          
  
         $filter->like('wm_id_no', __('WM ID NO'));
   
    });
       $grid->quickSearch('date', 'call_time', 'candidate_name', 'fathers_name', 'mothers_name', 'house_name', 'mob_1', 'mob_2',
        'gender','date_of_birth', 'age', 'religion', 'cast', 'candidate_watsupno', 'candidate_email', 'workplace', 'plan_details',
        'qualification','occupation','country','state','place','calling_status','wm_id_no','marital_status');
        
         if (Admin::user()->inRoles(['Administrator', 'Manager'])){
   // $grid->model()->whereNotNull('created_id');
    $grid->column('user1.name', __('Staff Name'));
}
        
        return $grid;
    }

    protected function detail($id)
    {
        $show = new Show(Custregister::findOrFail($id)); // Use the Bussiness model

        $show->field('id', __('ID'));
        $show->field('date', __('Date'));
        $show->field('in_time', __('In Time'));
        $show->field('expectations', __('Expectations'));
        $show->field('family_status', __('Family Status'));
        $show->field('house_details', __('House Details'));
        $show->field('service_charge_details', __('Service Charge Details'));
        $show->field('matching_profile_details', __('Matching Profile Details'));
        $show->field('payment_chance', __('Payment Chance'));
        $show->field('payment_details', __('Payment Details'));
        $show->field('offer', __('Offer'));
        $show->field('location', __('Location'));
        $show->field('landmark', __('Landmark'));
        $show->field('latitude','Latitude');
        $show->field('longitude','Longitude');
        $show->field('out_time', __('Out Time'));
        $show->field('remark', __('Remark'));
        $show->field('created_at', __('Created At'));
        $show->field('updated_at', __('Updated At'));

        return $show;
    }


    protected function form()

    {
     
       $form = new Form(new Custregister()); // Use the Business model

    $form->radioCard('custmer', __('Costumer'))->options(['1'=> 'Show Details','0'=>'Hide Deatils'])
     ->when(1, function (Form $form) {
     
        $form->text('candidate_name', __('Candidate Name'));//->value($custregisterId->candidate_name);
        $form->text("fathers_name", __("Father's Name"));//->value($custregisterId->fathers_name);
        $form->text("mothers_name", __("Mother's Name"));//->value($custregisterId->mothers_name);
        $form->textarea('house_name', __('Address '));//->rows(5)->style('width', '300px; height: 150px;')->value($custregisterId->house_name);
        $form->text('place', __('Place/Area'))->setWidth(4, 2);
        $form->mobile('mob_1', __('First Mobile Number'))->options(['mask' => '+99 999 999 9999'])->setWidth(4, 2);//->value($custregisterId->mob_1);
        $form->mobile('mob_2', __('Second Mobile Number'))->options(['mask' => '+99 999 999 9999'])->setWidth(4, 2);//->value($custregisterId->mob_2);
        $form->date('date_of_birth', __('Date of Birth')) ->default(today()->format('d-m-Y'))
         ->format('DD-MM-YYYY');//->default(date('Y-m-d'))->setWidth(4, 2)->value($custregisterId->date_of_birth);
      $form->number('age', __('Age'));//->value($custregisterId->age);
         $form->select('religion', __('Religion'))->options(Religion::pluck('religion','religion'))->setWidth(4, 2);
        //  $form-> select('cast',__('Cast'))->options(Cast::pluck('cast_name','cast_name'));
       $form-> select('cast',__('Cast'))->options(Cast::pluck('cast_name','id'))->setWidth(4, 2);
              $form->text('qualification', __('Qualification'))->setWidth(4, 2);
          $form->text('occupation', __('Occupation'))->setWidth(4, 2);
        $form->text('workplace', __('Workplace'))->setWidth(4, 2);
         
          })->default(0);
 
        $form->date('b_date', __('Date')) ->default(today()->format('d-m-Y'))
    ->format('DD-MM-YYYY');
        $form->time('in_time', __(' Check In Time'))->format('h:mm:ss a');
        $form->select('family_status', __('Family Status'))->options([1=>'Rich', 2 => 'Upper Middile Class',3 =>'Middile Class',4=>'Lower Middile Class',5=>'Poor Family'])->setWidth(4, 2);
       // $form->textarea('house_details', __('Address'))->rows(5)->style('width', '300px; height: 150px;')->setWidth(4, 2);
         $form->select('complexion', __('Complexion'))->options([1=>'Very Fair', 2 => 'Fair',3 =>'Wheatish',4 =>'Dark',5 =>'Wheatish Brown'])->setWidth(4, 2);
        $form->textarea('service_charge_details', __('Service Charge Details'))->rows(5)->style('width', '300px; height: 150px;')->setWidth(4, 2);
        $form->textarea('matching_profile_details', __('Matching Profile Details'))->rows(5)->style('width', '300px; height: 150px;')->setWidth(4, 2);
        $form->select('payment_chance', __('Payment Chance'))->options([1=>'25%', 2 => '50%',3 =>'75%',4=>'100%'])->setWidth(4, 2);
        $form->textarea('payment_details', __('Payment Details'))->rows(5)->style('width', '300px; height: 150px;')->setWidth(4, 2);
        $form->text('offer', __('Offer'))->setWidth(4, 2);
         $form->textarea('expectations', __('Expectations'))->rows(5)->style('width', '650px; height: 300px;')->setWidth(4, 2);
        $form->text('location', __('Location'))->setWidth(4, 2);
        $form->text('landmark', __('Landmark'))->setWidth(4, 2);
        //$form->text('latitude', __('latitude'))->readonly();
       // $form->text('longitude', __('longitude'))->readonly();
        $form->map('latitude' , 'longitude', 'Map')->useGoogleMap();
        // $form->map('latitude', 'longitude')->useGoogleMap();
        $form->time('out_time', __('Out Time'))->format('h:mm:ss a');
        $form->textarea('b_remarks', __('Remark'))->rows(5)->style('width', '300px; height: 150px;')->setWidth(4, 2);
        $form->hidden('visits_status')->default(intval(1));
       
         $form->saving(function (Form $form) {
        $dateOfBirth = $form->input('date_of_birth');
            if ($dateOfBirth) {
                $dateOfBirth = Carbon::parse($dateOfBirth);
                $age = Carbon::now()->diffInYears($dateOfBirth);
                $form->input('age', $age);
            }
             //$custregister = Custregister::where('appointment', 1)
           // ->where('task_status', 0)->all();
            $custregister = $form->model()->id;
            $role = Admin::user()->roles;
            
              $loginId = Admin::user()->id;

        if ($custregister && $role) {
    // Assuming that $roles is a collection of roles
    $roleNames = $role->pluck('name')->implode(', ');

            $tracks = new WorkTracking();
            $tracks->customer_id = $custregister;
            $tracks->user_id =  $loginId;
            $tracks->role_name =  $roleNames;
          
            // Save the Visits record
            $tracks->save();
        }
            
        });
         $form->tools(function (Form\Tools $tools) {

                 
    // Disable `Veiw` btn.
    $tools->disableView();

  
});

        return $form;
    }
    
   



    
     
}