<?php

namespace App\Admin\Controllers;
use App\Models\Destinationcategory;
use App\Models\Category;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;

class DestinationCategoryController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'DestinationCategory';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
       $grid = new Grid(new Destinationcategory());
         $grid->column('id',__('ID'));
        //$grid->column('categories.name',__('Category'))->sortable();
        $grid->column('categoryname',__('Category Name'));
        $grid->column('image',__('Image'))->image('',60,60);
       $grid->column('active',__('Active'))->display(function ($active) {
           if($active ===Constant::STATUS_NO){
               return "No";
           }else{
               return "Yes";
           }});
       

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     *@click and view projects
     */
    protected function detail($id) 
    {
        
        $show = new Show(Destinationcategory::findOrFail($id));
         $show->field('Id',__('ID'));
        $show->field('categoryname',__('Category Name'));
        $show->field('image',__('Image'))->image('',60,60);
       $show->field('active',__('Active'))->display(function ($active) {
           if($active ===Constant::STATUS_NO){
               return "No";
           }else{
               return "Yes";
           }});
       
        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */


    protected function form() //form add/edit
    {
        $form = new Form(new Destinationcategory());
        
       
        $form->text('categoryname',__('Category Name'))->rules('required|max:200')->setWidth(4, 2);
        $form->select('parent_id',__('Select Group'))->options(Category::where('type','D')->pluck('name','Id'))->setWidth(4, 2)->rules('required');
        $form->cropper('image',__('Image'))->cRatio('330','260')->removable()->move('places/images');
        $form->text('order',__('Order'))->setWidth(4, 2)->rules('required|numeric');
        $form->switch('active',__('Active'))->states(Constant::STATUS)->default(1);
        return $form;
    }
}
