<?php
namespace App\Admin\Controllers;

use Illuminate\Http\Request;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Complaints;
use Encore\Admin\Controllers\AdminController;
use App\Models\Constant;
use Carbon\Carbon;
use Encore\Admin\Facades\Admin;
Use Encore\Admin\Widgets\Table;
Use Illuminate\Support\Str;

class ComplaintsController extends AdminController
{
 /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Complaints';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new  Complaints());
        $grid->column('id',__('ID'));
        $grid->column('costumer_name',__('Costumer Name')); 
        $grid->column('wedline_id',__('Wedline ID')); 
        $grid->column('contact_number',__('Contact Number'));
      
        $grid->column('complaint','Complaints')->ucfirst()->substr(0, 30)->expand(function ($model) {

        $Complaint = $model->complaints('id')->take(10)->get()->map(function ($Complaint) {
        return $Complaint->only('complaint');
        });

        return new Table(['Complaints'], $Complaint->toArray());
        });
       
        $grid->column('date',__('Date'));  
        

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     *@click and view projects
     */
    protected function detail($id) 
    {
        
        $show = new Show(Complaints::findOrFail($id));
        $show->field('id',__('Id'));
         $show->field('costumer_name',__('Costumer Name')); 
        $show->field('wedline_id',__('Wedline ID')); 
        $show->field('contact_number',__('Contact Number'));
       
        $show->field('complaint',__('Complaint'));
         $show->field('date',__('Date'));  

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */


    protected function form() //form add/edit
    {
         $loginId = Admin::user()->id;
          $loginUser = Admin::user()->name;
        $form = new Form(new Complaints());
        $form->text('costumer_name',__('Costumer Name'));
        $form->text('wedline_id',__('Wedline ID'));
       $form->mobile('contact_number',__('Contact Number'))->options(['mask' => '999 999 9999'])->setWidth(4, 2);
        $form->textarea('complaint',__('Complaint'));
        $form->datetime('date',__('Date'))->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a');
        $form->hidden('created_id')->default( $loginId);
         $form->hidden('createdby')->default( $loginUser);

        return $form;
    }
}