<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use App\Models\Custregister;

use App\Models\Notifications;
use Carbon\Carbon;

class ShowNotifications extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'show:notifications';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $dateString = now()->toDateString();
        $records = Custregister::where('payment_reminder', $dateString )->get();
         $caling = Custregister::where('calling_reminder', $dateString )->get();

        foreach ($records as $record) {
          
            Notifications::create([
                'customer_id' => $record->id,
                'note' => $record->payment_note,
                'read' => 0,

            ]);

            // You can customize the 'message' field as needed.
        }

  foreach ($caling as $call) {
         
            Notifications::create([
                'customer_id' => $call->id,
                'note' => $call->calling_status,
                'read' => 0,
                'user_id' => $call->created_id,
                'cust_name' => $call->candidate_name,
            ]);

            // You can customize the 'message' field as needed.
        }

        $this->info('Updated pending_remainder and created notifications.');

        return 0;
    }
}
