<?php

namespace App\Admin\Controllers;

use App\Models\Complaints;
use App\Models\Users;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use Illuminate\Http\Request;
Use Encore\Admin\Widgets\Table;
Use Illuminate\Support\Str;
use DB;

class ComplaintAssignController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Complaint Assign Page';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
       $grid = new Grid(new  Complaints());
        $grid->column('id',__('ID'));
        $grid->column('costumer_name',__('Costumer Name')); 
        $grid->column('wedline_id',__('Wedline ID')); 
        $grid->column('contact_number',__('Contact Number'));
         $grid->column('createdby',__('Registered By'));

       $grid->column('complaint','Complaints')->ucfirst()->substr(0, 30)->modal('Registered Complaints', function ($model) {

            $comments = $model->complaints('id')->take(10)->get()->map(function ($comment) {
                return $comment->only('complaint');
            });
            
                return new Table(['complaints'],$comments->toArray());
            });
        $grid->column('date',__('Date'));  
          $grid->column('remarks', __('Remarks'))->editable('textarea');
        $grid->column('assign_to', __('Assign To'))->editable('select',(Users::pluck('name','id')));

         $grid->disableCreateButton();

      $grid->actions(function ($actions) {
            $actions->disableEdit();
             $actions->disableView();// Disable the view action
        });

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
     protected function detail($id) 
    {
        
        $show = new Show(Complaints::findOrFail($id));
        $show->field('id',__('Id'));
         $show->field('costumer_name',__('Costumer Name')); 
        $show->field('wedline_id',__('Wedline ID')); 
        $show->field('contact_number',__('Contact Number'));
       
        $show->field('complaint',__('Complaint'));
         $show->field('date',__('Date'));  

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */


    protected function form() //form add/edit
    {
        
        $form = new Form(new Complaints());
       
          $form->hidden('assign_to', 'Assign_To')->options(Users::all()->pluck('name', 'id'))->setWidth(4, 2)->rules('required');
        $form->hidden('remarks', __('Remarks'));
     
        return $form;
    }
}
