<?php

namespace App\Admin\Controllers;

use Illuminate\Support\Facades\Request;
use App\Models\Custregister;
use App\Models\Visits;
use App\Models\Country;
use App\Models\Package;
use App\Models\State;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use App\Models\Constant;
use App\Models\Religion;
use App\Models\WorkTracking;
use App\Models\Cast;
use Carbon\Carbon;

use Encore\Admin\Facades\Admin;


class OldDataAddingController extends AdminController
{
   
  /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Previous Data Register';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
       
        $grid = new Grid(new Custregister());
         
       
       $grid->model()->orderBy('id', 'desc');
//$slNo = 0; // Initialize the increment value

//$grid->rows(function (Grid\Row $row) use (&$slNo) {
    //$slNo++; 
    //$row->column('Sl No', $slNo);
//});
// Your custom column.
//$grid->column('Sl No');

        $grid->column('id',__('SL.NO'))->display(function ($id) {
   $totalRecords = Custregister::count();
    $position = $totalRecords - $this->getKey() + 1;
    return $position;
});
        $grid->column('date', __('Date'))->display(function ($date) {
        return date('d-m-Y', strtotime($date));
        })->hide();
        $grid->column('call_time', __('Call Time'))->hide();
        $grid->column('candidate_name', __('Candidate Name'));
        $grid->column('fathers_name', __("Father's Name"));
        $grid->column('mothers_name', __("Mother's Name"))->hide();
        $grid->column('house_name', __('House Name'))->hide();
        $grid->column('mob_1', __('Mobile 1'));
        $grid->column('mob_2', __('Mobile 2'));
        $grid->column('gender', __('Gender'))->hide();
        $grid->column('date_of_birth', __('Date Of Birth'))->hide();
        $grid->column('age', __('Age'));
        $grid->column('religion', __('Religion'));
        $grid->column('cast', __('Cast'))->hide();
        $grid->column('candidate_watsupno', __('Candidate WhatsApp Number'))->hide();
        $grid->column('candidate_email', __('Candidate Email'))->hide();
        $grid->column('workplace', __('Workplace'))->hide();
        $grid->column('qualification', __('Qualification'))->hide();
        $grid->column('remark', __('Remark'))->hide();
        $grid->column('task_status', __('task_status'))->hide();
       // $grid->column('follow_up', __('Follow Up'))->hide();
        $grid->column('appointment', __('Appointment'))->display(function ($appointment) {
            if($appointment === 2){
                return "No";
            }else{
                return "Yes";
            }})->hide();
        $grid->column('appointment_date', __('Appointment Date'))->hide();
        $grid->column('appointment_time', __('Appoinment_Time'))->hide();
        $grid->column('appointment_note', __('Appoinment_Note'))->hide();

            $grid->filter(function ($filter) {
            // Disable the default ID filter
            $filter->disableIdFilter();
            });

            $grid->quickSearch('date', 'call_time', 'candidate_name', 'fathers_name', 'mothers_name', 'house_name', 'mob_1', 'mob_2',
        'gender','date_of_birth', 'age', 'religion', 'cast', 'candidate_watsupno', 'candidate_email', 'workplace', 'plan_details',
        'qualification','occupation',);

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {   
       

        $show = new Show(Custregister::findOrFail($id));

        $show->field('id', __('ID'));
        $show->field('date', __('Date'));
        $show->field('call_time', __('Call Time'));
        $show->field('candidate_name', __('Candidate Name'));
        $show->field('fathers_name', __("Father's Name"));
        $show->field('mothers_name', __("Mother's Name"));
        $show->field('house_name', __('House Name'));
        $show->field('mob_1', __('Mobile 1'));
        $show->field('mob_2', __('Mobile 2'));
        $show->field('gender', __('Gender'));
        $show->field('date_of_birth', __('Date of Birth'));
        $show->field('religion', __('Religion'));
        $show->field('cast', __('Cast'));
        $show->field('candidate_watsupno', __('Candidate WhatsApp Number'));
        $show->field('candidate_email', __('Candidate Email'));
        $show->field('workplace', __('Workplace'));
        $show->field('qualification', __('Qualification'));
        $show->field('remark', __('Remark'));
        $show->field('appointment', __('Appointment'));
        $show->field('appointment_date', __('Appoinment_Date'));
        $show->field('appointment_time', __('Appoinment_Time'));
        $show->field('appointment_note', __('Appoinment_Note'));
       
        return $show;
    }

    protected function form()
    {
          $loginId = Admin::user()->id;

        $form = new Form(new Custregister());
         
     
               $cat= new Religion(); 

        $form->date('date', __('Date'))->default(today()->format('d-m-Y'))
    ->format('DD-MM-YYYY');
        $form->time('call_time', __('Calling Time'))->format('h:mm:ss a');

        $form->text('candidate_name', __('Candidate Name'))->setWidth(4, 2);
        $form->text("fathers_name", __("Father's Name"))->setWidth(4, 2);
        $form->text("mothers_name", __("Mother's Name"))->setWidth(4, 2);
        $form->textarea('house_name', __('Address'))->rows(5)->style('width', '300px; height: 150px;');

        $form-> select('country',__('Country'))->options(Country::pluck('name','name'))->setWidth(4, 2);
         $form-> select('state',__('State'))->options(State::pluck('state_name','state_name'))->setWidth(4, 2);

        $form->mobile('mob_1', __('First Mobile Number'))->options(['mask' => '999 999 9999'])->setWidth(4, 2);
        $form->mobile('mob_2', __('Second Mobile Number'))->options(['mask' => '999 999 9999'])->setWidth(4, 2);
        $form->radioCard('gender', __('Gender'))->options(['Male' => 'Male', 'Female' => 'Female'])->stacked();
       $form->date('date_of_birth', __('Date of Birth'))
    ->default(today()->subYears(18)->format('d-m-Y'))
    ->format('DD-MM-YYYY')
    ->setWidth(4, 2);
   /* ->rules(function ($field, $value) {
        $eighteenYearsAgo = Carbon::now()->subYears(18)->startOfDay();
        return [
            'required',
            'date',
            'before_or_equal:' . $eighteenYearsAgo->format('Y-m-d'),
        ];
    });*/
        $form->hidden('age', __('Age')) ->setWidth(4, 2);
        $form->select('religion', __('Religion'))->options(Religion::pluck('religion','religion'))->setWidth(4, 2);
         $form->select('cast',__('Cast'))->options(Cast::pluck('cast_name','cast_name'))->setWidth(4, 2);

       
    /* $form->select('religion_id', __('Religion'))
    ->options($cat::pluck('religion', 'id'))
    ->setWidth(4, 2)
    ->rules('required')
    ->load('religion_id', '/api/casts'); 
     $form->select('cast',__('Cast'))->setWidth(4, 2)->options(function($cast){
            $s = [];
            $sub_cat = Cast::find($cast);
            if($cast){
                $all_cast = Cast::select('id','cast_name')->where('religion_id',$sub_cat->religion_id)->get();
                foreach($all_cast as $sub){
                    $s[$sub->id]=$sub->cast_name;
                }
            }
            return $s;
        });
*/

/*
  $form->select('cat_id',__('Category'))
        ->options($cat::all()->pluck('name', 'id'))->setWidth(4, 2)->rules('required')
        ->load('sub_cat_id', '/admin/api/sub-categories');
        
        $form->select('sub_cat_id',__('Sub category'))->setWidth(4, 2)->options(function($sub_cat_id){
            $s = [];
            $sub_cat = SubCategory::find($sub_cat_id);
            if($sub_cat_id){
                $all_sub_cat =SubCategory::select('id','name')->where('cat_id',$sub_cat->cat_id)->get();
                foreach($all_sub_cat as $sub){
                    $s[$sub->id]=$sub->name;
                }
            }
            return $s;
        });

*/



        $form->text('candidate_watsupno', __('Candidate WhatsApp Number'))->setWidth(4, 2);
        $form->email('candidate_email', __('Candidate Email'))->setWidth(4, 2);
        $form->text('workplace', __('Workplace'))->setWidth(4, 2);
        $form->text('qualification', __('Qualification'))->setWidth(4, 2);
        $form->text('remark', __('Remark'))->setWidth(4, 2);
        $form->select('datasource', __('Data Source'))->options(['1'=> 'Advertisement','2'=> 'Refferal','3'=> 'Direct','4'=> 'Facebook','5'=>'Instagram','6'=>'Youtube',
       ' 7'=> '	Newspaper Advertisment',
       ' 8'=> '	Theater Advertisment',
       ' 9'=> '	Magazine Advertisment',
       '10'=> '	Tele-in',
        '11'=> '	Telemarketting',
        '12'=> '	Event/Activity',
       ' 13'=> '	Hoarding',
        '14'=> '	Notice/Pamphelt',
        '15'=> '	Radio',
        '16'=> '	Google Search',
        '17	'=> 'Social Media',
        '18'=> '	Others'
])
        ->when(2, function (Form $form) {
        $form->text('refferal_name', __('Refferal Name'));
        })->setWidth(4, 2);
        $form->hidden('task_status', __('task_status'))->default(0);
      
        $form->table('follow_up','Follow up', function ($table) {
               
                $table->text('follow_up')->rules('required');
                $table->datetime('date')->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a');
            });

        $form->radioCard('appointment','Appointment')
        ->options([
            1 =>'YES',
            0 =>'NO',
        ])->when(1, function (Form $form) {
           
           $form->date('appointment_date', __('Appointment Date')) ->default(today()->format('d-m-Y'))
    ->format('DD-MM-YYYY');
           $form->time('appointment_time', __('Appointment Time'))->format('h:mm:ss a');
           $form->textarea('appointment_note', __('Appointment Note'))->rows(5)->style('width', '600px')->style('height', '150px');
    
        })->when(0, function (Form $form) {
            
            $form->hidden('appointment_date', __('Appointment Date'))->default(date(''));
            $form->hidden('appointment_time', __('Appointment Time'))->default(date(''));
            $form->hidden('appointment_note', __('Appointment Note'))->default('');
    
        });
           $form->select('family_status', __('Family Status'))->options([1=>'Rich', 2 => 'Upper Middile Class',3 =>'Middile Class',4=>'Lower Middile Class',5=>'Poor Family'])->setWidth(4, 2);
       // $form->textarea('house_details', __('Address'))->rows(5)->style('width', '300px; height: 150px;')->setWidth(4, 2);
         $form->select('complexion', __('Complexion'))->options([1=>'Very Fair', 2 => 'Fair',3 =>'Wheatish',4 =>'Dark',5 =>'Wheatish Brown'])->setWidth(4, 2);
        $form->textarea('service_charge_details', __('Service Charge Details'))->rows(5)->style('width', '300px; height: 150px;')->setWidth(4, 2);
        $form->textarea('matching_profile_details', __('Matching Profile Details'))->rows(5)->style('width', '300px; height: 150px;')->setWidth(4, 2);
        $form->select('payment_chance', __('Payment Chance'))->options([1=>'25%', 2 => '50%',3 =>'75%',4=>'100%'])->setWidth(4, 2);
        $form->textarea('payment_details', __('Payment Details'))->rows(5)->style('width', '300px; height: 150px;')->setWidth(4, 2);
        $form->text('offer', __('Offer'))->setWidth(4, 2);
         $form->textarea('expectations', __('Expectations'))->rows(5)->style('width', '650px; height: 300px;')->setWidth(4, 2);
        $form->text('location', __('Location'))->setWidth(4, 2);
        $form->text('landmark', __('Landmark'))->setWidth(4, 2);
        //$form->text('latitude', __('latitude'))->setWidth(4, 2);
        //$form->text('longitude', __('longitude'))->setWidth(4, 2);
        $form->map('latitude' , 'longitude', 'Map')->useGoogleMap();
        // $form->map('latitude', 'longitude')->useGoogleMap();
        $form->time('out_time', __('Out Time'))->format('h:mm:ss a');
        $form->textarea('b_remarks', __('Remark'))->rows(5)->style('width', '300px; height: 150px;')->setWidth(4, 2);
        $form->hidden('visits_status')->default(intval(1));
         //$cust = $form->model();
         
        $form->hidden('created_id')->default( $loginId);
      $form->switch('profile_verification', __('Profile Verification'))->states(Constant::STATUS)->default(0);
        $form->datetime('registration_dt', __('Registration Date/Time'))->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a');
       $form->radioCard('registration_status','Ragistration Status')->options([
           
            '1'=> 'YES', '0'=>'PENDING'
            ])
        ->when(1, function(form $form){

        $form->text('wm_id_no', __('WM ID NO'));
       $form->select('payment_chance', __('Payment Chance'))->options([1=>'25%', 2 => '50%',3 =>'75%',4=>'100%'])->setWidth(4, 2);
         $form->radio('member_status', __('Member Status'))->options([
            '0' => 'Free',
            '1' => ' Advance', 
            '2' => 'Paid',
            '3' => 'Not Interest'
            ])->when (1, function(form $form){

        $form->select('plan_details', __('Plan details'))->options(Package::all()->pluck('name', 'name'));
         $form->select('duration', __('Duration'))->options(Package::all()->pluck('duration', 'id'));
         $form->dateRange('start_date', 'end_date', 'Date Range');
        $form->text('invoice_no', __('Invoice No'));
        $form->text('invoice_date', __('Invoice Date'));
        $form->text('offer_details', __('Offer Details'));
         $form->select('payment_mode', __('Payment Mode'))->options([
            '0' => 'Net Banking',
            '1' => ' Bank Transfer', 
            '2' => 'UPI',
            '3' => 'Cash',
            '4' => 'Others'
            ]);
         $form->text('payment_note', __('Payment Note'));
         $form->date('payment_reminder', __('Payment Reminder')) ->default(today()->format('d-m-Y'))
    ->format('DD-MM-YYYY');

      $form->table('matching_profile','Matching Profile Details', function ($table) {

                $table->text('matching_profile_id','Matching Profile Id')->rules('required');
                $table->text('matching_profile_name','Matching Profile Name')->rules('required');
                $table->datetime('data_date_time')->default(today()->format('d-m-Y H:m a'))
    ->format('DD-MM-YYYY h:mm:ss a');
                 $table->select('matching_status', __('Matching Status'))->options(['1'=>'Pending',2=> 'Interest',3=> 'Not Interest',4=> 'Declaine']);
            });


         })->when (2, function(form $form){

          $form->select('plan_details', __('Plan details'))->options(Package::all()->pluck('name', 'name'));
           $form->select('duration', __('Duration'))->options(Package::all()->pluck('duration', 'duration'));
        $form->text('offer_details', __('Offer Details'));
          $form->table('p_matching_profile','Matching Profile Details', function ($table) {

                $table->text('matching_profile_id','Matching Profile Id')->rules('required');
                $table->text('matching_profile_name','Matching Profile Name')->rules('required');
                $table->datetime('data_date_time')->default(today()->format('d-m-Y H:m a'))
                ->format('DD-MM-YYYY h:mm:ss a');
                $table->select('matching_status', __('Matching Status'))->options(['1'=>'Pending',2=> 'Interest',3=> 'Not Interest',4=> 'Declaine']);
    
            });


         })->when (0, function(form $form){

              $form->date('payment_reminder', __('Payment Reminder'));
              $form->table('f_matching_profile','Matching Profile Details', function ($table) {

                $table->text('matching_profile_id','Matching Profile Id')->rules('required');
                $table->text('matching_profile_name','Matching Profile Name')->rules('required');
                $table->datetime('data_date_time')->default(today()->format('d-m-Y H:m a'))
                ->format('DD-MM-YYYY h:mm:ss a');
                $table->select('matching_status', __('Matching Status'))->options(['1'=>'Pending',2=> 'Interest',3=> 'Not Interest',4=> 'Declaine']);
    
            });
         })->default(0);

        })->when (0,function(form $form){
           $form->date('pending_reminder', __('Pending Reminder')) ->default(today()->format('d-m-Y'))->format('DD-MM-YYYY');
        });
       
        $form->divider();
        
         //$form->text('matching_profile', __('Matching Profile'));
       
         $form->hidden('created_id')->default( intval(1));
         $form->hidden('data_status')->default(intval(2));
          $form->hidden('assign_to')->default( intval(1));
           $form->hidden('data_assign')->default( intval(1));
        $form->divider();

        $form->saving(function (Form $form) {
        $dateOfBirth = $form->input('date_of_birth');
            if ($dateOfBirth) {
                $dateOfBirth = Carbon::parse($dateOfBirth);
                $age = Carbon::now()->diffInYears($dateOfBirth);
                $form->input('age', $age);
            }
             
            
        });


        return $form;
    }
}